; ****************************************************************************
; `DIVT' - Source code for `divt' object
;   Written by Robert Riebisch
;   Executable size optimized by Michal H. Tyc
;
; Copyright (c) 1997-2006 BTTR Software.  All rights reserved.
;
; This program is free software; you can redistribute it and/or modify it
; under the terms of the `MODIFIED' BSD LICENSE.  Please see `legal.txt'
; for details.
; ****************************************************************************

;%define DEBUG_PRINTCSEG  ; remove `;' to activate

; **********

  PSPSIZ Equ 100h  ; `Program segment prefix' size

; **********
  Section .code    ; start code segment
  CODESTART Equ $  ; start of code segment (unused)
; **********

  Org PSPSIZ  ; .COM file entry point
  Cpu 8086    ; limit instruction set

@main:
%ifdef DEBUG_PRINTCSEG
; get and convert code segment to hexadecimal string
  mov [cseg], cs
  mov si, cseg
  mov di, csegmsg + 24
  call wordtohexstr
  mov dx, csegmsg
; write csegmsg to console
  mov ah, 9
  int 21h
%endif
; point DS:SI to interrupt vector table (IVT) at 0:0
  xor ax, ax  ; AX = 0
  mov ds, ax  ; DS = 0
  mov si, ax  ; SI = 0

; main loop to process the IVT entry by entry
@nextint:
  push ax              ; backup interrupt number
  mov di, intmsg + 5   ; point DI to `0h:' of intmsg
  call bytetohexstr    ; convert interrupt number to hexadecimal string
  mov di, intmsg + 17  ; point DI to end of intmsg
  call wordtohexstr    ; load and convert offset to hexadecimal string
  dec di               ; skip `:' to point DI to `0:' of intmsg
  call wordtohexstr    ; load and convert segment too

  push ds         ; backup DS for iteration
; make DS:DX point to intmsg
  push cs         ; DS = CS
  pop ds
  mov dx, intmsg
; write intmsg to console
  mov ah, 9
  int 21h
  pop ds          ; restore DS

  pop ax        ; restore interrupt number
  inc al        ; +1
  jnz @nextint  ; loop until AL becomes 0 again

  ret  ; return to operating system

; **********

; convert word at DS:SI to hexadecimal string
wordtohexstr:
  call $ + 3    ; process low byte first
                ;   (call to `lodsb' + bytetohexstr())
  lodsb         ; ...then high byte

; **********

; convert AL to hexadecimal string
bytetohexstr:
  push ax       ; backup high nibble
  call .nibble  ; process lower 4 bits
  pop ax        ; restore high nibble
  mov cl, 4     ; ...and move it downwards
  shr al, cl
.nibble:
  and al, 0fh       ; ignore upper 4 bits
  cmp al, 10        ; set CF if AL < 10
  sbb al, 99h - '0' ; 0..9 -> 96h..9fh (and set AF), 10..15 -> 0a1h..0a6h
  das               ; 96h..9fh -> '0'..'9' (CF was 1), 0a1h..0a6h -> 'A'..'F'
  std               ; write to string from right to left...
  stosb             ; save that character
  cld               ; ...but read forwards from IVT
  ret

; **********
  CODEEND Equ $                    ; end of code segment
  CODELEN Equ CODEEND - CODESTART  ; code segment length (unused)

  Section .data Align=1  ; start data segment
  DATASTART Equ $        ; start of data segment (unused)
; **********

%ifdef DEBUG_PRINTCSEG
csegmsg: Db 'DIVT', 39, 's code segment: 0000h', 13, 10, 13, 10, '$'
%endif

intmsg: Db 'Int 00h: 0000:0000', 13, 10, '$'

; **********
  DATAEND Equ $                    ; end of data segment
  DATALEN Equ DATAEND - DATASTART  ; data segment length (unused)

  Section .bss Align=1  ; start bss segment
  BSSSTART Equ $        ; start of bss segment (unused)
; **********

%ifdef DEBUG_PRINTCSEG
cseg: Resw 1  ; current code segment
%endif

; **********
  BSSEND Equ $                  ; end of bss segment
  BSSLEN Equ BSSEND - BSSSTART  ; bss segment length (unused)
; **********

; (end of `divt.asm')
