# ****************************************************************************
# `zip.mak' - Makefile to create ZIP archives for distribution
#   Written by Robert Riebisch
#   Modified for Info-ZIP Zip by Michal H. Tyc
# ****************************************************************************

# some basic error checking
!if !$d(AR) || !$d(ARFLAGS) || !$d(ARNODIRS) || !$d(ARSUBDIRS) || !$d(PROJECT)
  !error Don't call this Makefile directly!
!endif

# where to put ZIP files
.path.zip = ..

# public distribution archives
zip: $(PROJECT)b.zip $(PROJECT)s.zip

# binaries archive for public distribution
$(PROJECT)b.zip:
  -cd ..
  -if exist $@ del $@
  -$(AR) $(ARFLAGS) $(ARNODIRS) $@ *.*
  -cd source

# source code archive for public distribution
$(PROJECT)s.zip:
  -cd ..
  -if exist $@ del $@
  -$(AR) $(ARFLAGS) $(ARSUBDIRS) $@ \
     source\*.* file_id.diz legal.txt $(PROJECT).url
  -cd source

# --- for internal use ---
mirror: $(PROJECT)m.zip

# mirror archive for internal distribution
$(PROJECT)m.zip:
  -cd ..
  -if exist $@ del $@
  -$(AR) $(ARFLAGS) $(ARSUBDIRS) $@ *.*
  -cd source
